/*
* hal_pnl.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#ifndef _HAL_PNL_H_
#define _HAL_PNL_H_

//-------------------------------------------------------------------------------------------------
//  Defines & Macro
//-------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------
//  structure & Enum
//-------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------
//  Prototype
//-------------------------------------------------------------------------------------------------

#ifdef _HAL_PNL_C_
#define INTERFACE
#else
#define INTERFACE extern
#endif


INTERFACE bool HalPnlGetLpllIdx(u32 u32Dclk, u16 *pu16Idx, bool bDsi);
INTERFACE u16  HalPnlGetLpllGain(u16 u16Idx, bool bDsi);
INTERFACE u16  HalPnlGetLpllDiv(u16 u16Idx, bool bDsi);
INTERFACE void HalPnlSetTTLPadMux(HalPnlOutputFormatBitMode_e enFmt);
INTERFACE void HalPnlSetMipiDisPadMux(HalPnlMipiDsiLaneMode_e enLaneNum);
INTERFACE void HalPnlSetTtlPadCotnrol(u32 u32Ie, u32 u32Pe, u32 u32Ps, u32 u32Drv);
INTERFACE void HalPnlDumpLpllSetting(u16 u16Idx);
INTERFACE void HalPnlSetLpllSet(u32 u32LpllSet);
INTERFACE void HalPnlSetClk(bool bEn, bool bDsi);
INTERFACE void HalPnlSetFrameColorEn(bool bEn);
INTERFACE void HalPnlSetFrameColor(u16 u16R, u16 u16G, u16 u16B);
INTERFACE void HalPnlSetVSyncSt(u16 u16Val);
INTERFACE void HalPnlSetVSyncEnd(u16 u16Val);
INTERFACE void HalPnlSetVfdeSt(u16 u16Val);
INTERFACE void HalPnlSetVfdeEnd(u16 u16Val);
INTERFACE void HalPnlSetVdeSt(u16 u16Val);
INTERFACE void HalPnlSetVdeEnd(u16 u16Val);
INTERFACE void HalPnlSetVtt(u16 u16Val);
INTERFACE void HalPnlSetHSyncSt(u16 u16Val);
INTERFACE void HalPnlSetHSyncEnd(u16 u16Val);
INTERFACE void HalPnlSetHfdeSt(u16 u16Val);
INTERFACE void HalPnlSetHfdeEnd(u16 u16Val);
INTERFACE void HalPnlSetHdeSt(u16 u16Val);
INTERFACE void HalPnlSetHdeEnd(u16 u16Val);
INTERFACE void HalPnlSetHtt(u16 u16Val);
INTERFACE void HalPnlSetClkInv(bool bEn);
INTERFACE void HalPnlSetVsyncInv(bool bEn);
INTERFACE void HalPnlSetHsyncInv(bool bEn);
INTERFACE void HalPnlSetDeInv(bool bEn);
INTERFACE void HalPnlSetVsynRefMd(bool bEn);
INTERFACE void HalPnlW2BYTEMSK(u32 u32Reg, u16 u16Val, u16 u16Msk);
INTERFACE void HalPnlSetTgenExtHsEn(u8 u8Val);
INTERFACE void HalPnlSetSwReste(u8 u8Val);
INTERFACE void HalPnlSetFifoRest(u8 u8Val);
INTERFACE void HalPnlSetDacHsyncSt(u16 u16Val);
INTERFACE void HalPnlSetDacHsyncEnd(u16 u16Val);
INTERFACE void HalPnlSetDacHdeSt(u16 u16Val);
INTERFACE void HalPnlSetDacHdeEnd(u16 u16Val);
INTERFACE void HalPnlSetDacVdeSt(u16 u16Val);
INTERFACE void HalPnlSetDacVdeEnd(u16 u16Val);
INTERFACE void HalPnlSetRgbMode(HalPnlOutputFormatBitMode_e enFmt);
INTERFACE void HalPnlSetDispToDsiMd(u8 u8Val);
INTERFACE void HalPnlSetLpllSkew(u16 u16Val);
INTERFACE void HalPnlSetRgbSwap(HalPnlRgbSwapType_e enChR, HalPnlRgbSwapType_e enChG, HalPnlRgbSwapType_e enChB);
INTERFACE void HalPnlSetRgbMlSwap(u8 u8Val);

INTERFACE void HalPnlInitMipiDsiDphy(void);
INTERFACE void HalPnlSetMipiDsiPadOutSel(HalPnlMipiDsiLaneMode_e enLaneMode);
INTERFACE void HalPnlResetMipiDsi(void);
INTERFACE void HalPnlEnableMipiDsiClk(void);
INTERFACE void HalPnlDisableMipiDsiClk(void);
INTERFACE void HalPnlSetMipiDsiLaneNum(HalPnlMipiDsiLaneMode_e enLaneMode);
INTERFACE void HalPnlSetMipiDsiCtrlMode(HalPnlMipiDsiCtrlMode_e enCtrlMode);
INTERFACE bool HalPnlGetMipiDsiClkHsMode(void);
INTERFACE void HalPnlSetMpiDsiClkHsMode(bool bEn);
INTERFACE bool HalPnlGetMipiDsiShortPacket(u8 u8ReadBackCount, u8 u8RegAddr);
INTERFACE bool HalPnlSetMipiDsiShortPacket(u8 u8Count, u8 u8Cmd, u8 *pu8ParamList);
INTERFACE bool HalPnlSetMipiDsiLongPacket(u8 u8Count, u8 u8Cmd, u8 *pu8ParamList);
INTERFACE bool HalPnlSetMipiDsiPhyTimConfig(HalPnlMipiDsiConfig_t *pstMipiDsiCfg);
INTERFACE bool HalPnlSetMipiDsiVideoTimingConfig(HalPnlMipiDsiConfig_t *pstMipiDsiCfg, HalPnlHwMipiDsiConfig_t *pstHwCfg);
INTERFACE void HalPnlGetMipiDsiReg(u32 u32Addr, u32 *pu32Val);
INTERFACE void HalPnlSetMipiDsiChSel(HalPnlMipiDsiConfig_t *pstMipiDisCfg);
INTERFACE void HalPnlSetMipiDsiPatGen(void);


#undef INTERFACE
#endif
